/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */        
#ifndef DM8127_GPIO_H_
#define DM8127_GPIO_H_

#define GPIO0_BASE			(0x48032000)
#define GPIO1_BASE			(0x4804C000)
#define GPIO2_BASE			(0x481AC000)
#define GPIO3_BASE			(0x481AE000)

#define GPIO0_SYSCONFIG		*(unsigned int *) (GPIO0_BASE + 0x010)
#define GPIO0_CTRL			*(unsigned int *) (GPIO0_BASE + 0x130)
#define GPIO0_OE			*(unsigned int *) (GPIO0_BASE + 0x134)
#define GPIO0_DATAIN		*(unsigned int *) (GPIO0_BASE + 0x138)
#define GPIO0_DATAOUT		*(unsigned int *) (GPIO0_BASE + 0x13C)
#define GPIO0_CLEARDATAOUT	*(unsigned int *) (GPIO0_BASE + 0x190)
#define GPIO0_SETDATAOUT	*(unsigned int *) (GPIO0_BASE + 0x194)

#define GPIO1_SYSCONFIG		*(unsigned int *) (GPIO1_BASE + 0x010)
#define GPIO1_CTRL			*(unsigned int *) (GPIO1_BASE + 0x130)
#define GPIO1_OE			*(unsigned int *) (GPIO1_BASE + 0x134)
#define GPIO1_DATAIN		*(unsigned int *) (GPIO1_BASE + 0x138)
#define GPIO1_DATAOUT		*(unsigned int *) (GPIO1_BASE + 0x13C)
#define GPIO1_CLEARDATAOUT	*(unsigned int *) (GPIO1_BASE + 0x190)
#define GPIO1_SETDATAOUT	*(unsigned int *) (GPIO1_BASE + 0x194)

#define GPIO2_SYSCONFIG		*(unsigned int *) (GPIO2_BASE + 0x010)
#define GPIO2_CTRL			*(unsigned int *) (GPIO2_BASE + 0x130)
#define GPIO2_OE			*(unsigned int *) (GPIO2_BASE + 0x134)
#define GPIO2_DATAIN		*(unsigned int *) (GPIO2_BASE + 0x138)
#define GPIO2_DATAOUT		*(unsigned int *) (GPIO2_BASE + 0x13C)
#define GPIO2_CLEARDATAOUT	*(unsigned int *) (GPIO2_BASE + 0x190)
#define GPIO2_SETDATAOUT	*(unsigned int *) (GPIO2_BASE + 0x194)

#define GPIO3_SYSCONFIG		*(unsigned int *) (GPIO3_BASE + 0x010)
#define GPIO3_CTRL			*(unsigned int *) (GPIO3_BASE + 0x130)
#define GPIO3_OE			*(unsigned int *) (GPIO3_BASE + 0x134)
#define GPIO3_DATAIN		*(unsigned int *) (GPIO3_BASE + 0x138)
#define GPIO3_DATAOUT		*(unsigned int *) (GPIO3_BASE + 0x13C)
#define GPIO3_CLEARDATAOUT	*(unsigned int *) (GPIO3_BASE + 0x190)
#define GPIO3_SETDATAOUT	*(unsigned int *) (GPIO3_BASE + 0x194)

/***
 * \brief: Routine to initialize the NAND Flash
 *
 * \b \Descr: This routine initialize the NAND flash by configuring GPMC.Reads
 * \n         the Manufacturer Id, Device Id and verifies the manufacture Id.
 *
 * \return: SUCCESS  on successful initialize.
 * \n       FAILED   Failed to initialized.
 *
 */
void GPIO_1_init
(
	void
);
/***
 * \brief: GPIO enable function for the WLAN
 *
 * \b \descr: This function initialzes the GPIO bank 0.
 *
 * \param:  VOID
 * \return: VOID
 */
void GPIO_0_init
(
	void
);
#endif /* DM8127_GPIO_H_ */

